/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message.tracker;

import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import xaero.map.WorldMapSession;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.client.ClientMessageConsumer;

public class ClientboundTrackedPlayerPacket
extends WorldMapMessage<ClientboundTrackedPlayerPacket> {
    private final boolean remove;
    private final UUID id;
    private final double x;
    private final double y;
    private final double z;
    private final ResourceLocation dimension;

    public ClientboundTrackedPlayerPacket(boolean remove, UUID id, double x, double y, double z, ResourceLocation dimension) {
        this.remove = remove;
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public void write(FriendlyByteBuf buffer) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("r", this.remove);
        nbt.m_128362_("i", this.id);
        if (!this.remove) {
            nbt.m_128347_("x", this.x);
            nbt.m_128347_("y", this.y);
            nbt.m_128347_("z", this.z);
            nbt.m_128359_("d", this.dimension.toString());
        }
        buffer.m_130079_((Tag)nbt);
    }

    public static ClientboundTrackedPlayerPacket read(FriendlyByteBuf buffer) {
        CompoundTag nbt = (CompoundTag)buffer.m_130081_(NbtAccounter.m_301669_());
        boolean remove = nbt.m_128471_("r");
        UUID id = nbt.m_128342_("i");
        double x = remove ? 0.0 : nbt.m_128459_("x");
        double y = remove ? 0.0 : nbt.m_128459_("y");
        double z = remove ? 0.0 : nbt.m_128459_("z");
        String dimensionString = remove ? null : nbt.m_128461_("d");
        ResourceLocation dimension = dimensionString == null ? null : new ResourceLocation(dimensionString);
        return new ClientboundTrackedPlayerPacket(remove, id, x, y, z, dimension);
    }

    public static class Handler
    implements ClientMessageConsumer<ClientboundTrackedPlayerPacket> {
        @Override
        public void handle(ClientboundTrackedPlayerPacket t) {
            WorldMapSession session = WorldMapSession.getCurrentSession();
            if (session == null) {
                return;
            }
            if (t.remove) {
                session.getMapProcessor().getClientSyncedTrackedPlayerManager().remove(t.id);
                return;
            }
            session.getMapProcessor().getClientSyncedTrackedPlayerManager().update(t.id, t.x, t.y, t.z, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)t.dimension));
        }
    }
}

