/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.util.PermissionCondition;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.AbstractPlatform;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.MultiUserPlatform;
import com.sk89q.worldedit.extension.platform.Preference;
import com.sk89q.worldedit.forge.CommandWrapper;
import com.sk89q.worldedit.forge.ForgeConfiguration;
import com.sk89q.worldedit.forge.ForgeDataFixer;
import com.sk89q.worldedit.forge.ForgePlayer;
import com.sk89q.worldedit.forge.ForgeRegistries;
import com.sk89q.worldedit.forge.ForgeResourceLoader;
import com.sk89q.worldedit.forge.ForgeWatchdog;
import com.sk89q.worldedit.forge.ForgeWorld;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.forge.internal.ExtendedChunk;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.io.ResourceLoader;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.registry.Registries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;

class ForgePlatform
extends AbstractPlatform
implements MultiUserPlatform {
    private final ForgeWorldEdit mod;
    private final ForgeDataFixer dataFixer;
    @Nullable
    private ForgeWatchdog watchdog;
    private boolean hookingEvents = false;
    private final ResourceLoader resourceLoader = new ForgeResourceLoader(WorldEdit.getInstance());
    private static final Set<SideEffect> SUPPORTED_SIDE_EFFECTS_NO_MIXIN = Sets.immutableEnumSet((Enum)SideEffect.VALIDATION, (Enum[])new SideEffect[]{SideEffect.ENTITY_AI, SideEffect.LIGHTING, SideEffect.NEIGHBORS, SideEffect.EVENTS});
    private static final Set<SideEffect> SUPPORTED_SIDE_EFFECTS = Sets.immutableEnumSet((Iterable)Iterables.concat(SUPPORTED_SIDE_EFFECTS_NO_MIXIN, Collections.singleton(SideEffect.UPDATE)));

    ForgePlatform(ForgeWorldEdit mod) {
        this.mod = mod;
        this.dataFixer = new ForgeDataFixer(this.getDataVersion());
    }

    boolean isHookingEvents() {
        return this.hookingEvents;
    }

    @Override
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public Registries getRegistries() {
        return ForgeRegistries.getInstance();
    }

    @Override
    public int getDataVersion() {
        return SharedConstants.m_183709_().m_183476_().m_193006_();
    }

    @Override
    public DataFixer getDataFixer() {
        return this.dataFixer;
    }

    @Override
    public boolean isValidMobType(String type) {
        return net.minecraftforge.registries.ForgeRegistries.ENTITY_TYPES.containsKey(new ResourceLocation(type));
    }

    @Override
    public void reload() {
        this.getConfiguration().load();
        super.reload();
    }

    @Override
    public int schedule(long delay, long period, Runnable task) {
        return -1;
    }

    @Override
    @Nullable
    public ForgeWatchdog getWatchdog() {
        MinecraftServer server;
        if (this.watchdog == null && (server = ServerLifecycleHooks.getCurrentServer()) instanceof DedicatedServer) {
            this.watchdog = new ForgeWatchdog((DedicatedServer)server);
        }
        return this.watchdog;
    }

    @Override
    public List<? extends World> getWorlds() {
        Iterable worlds = ServerLifecycleHooks.getCurrentServer().m_129785_();
        ArrayList<ForgeWorld> ret = new ArrayList<ForgeWorld>();
        for (ServerLevel world : worlds) {
            ret.add(new ForgeWorld(world));
        }
        return ret;
    }

    @Override
    @Nullable
    public Player matchPlayer(Player player) {
        if (player instanceof ForgePlayer) {
            return player;
        }
        ServerPlayer entity = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(player.getName());
        return entity != null ? new ForgePlayer(entity) : null;
    }

    @Override
    @Nullable
    public World matchWorld(World world) {
        if (world instanceof ForgeWorld) {
            return world;
        }
        for (ServerLevel ws : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            if (!((ServerLevelData)ws.m_6106_()).m_5462_().equals(world.getName())) continue;
            return new ForgeWorld(ws);
        }
        return null;
    }

    @Override
    public void registerCommands(CommandManager manager) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        Commands mcMan = server.m_129892_();
        for (Command command : manager.getAllCommands().collect(Collectors.toList())) {
            CommandWrapper.register((CommandDispatcher<CommandSourceStack>)mcMan.m_82094_(), command);
            Set perms = command.getCondition().as(PermissionCondition.class).map(PermissionCondition::getPermissions).orElseGet(Collections::emptySet);
            if (perms.isEmpty()) continue;
            perms.forEach(ForgeWorldEdit.inst.getPermissionsProvider()::registerPermission);
        }
    }

    @Override
    public void setGameHooksEnabled(boolean enabled) {
        this.hookingEvents = enabled;
    }

    @Override
    public ForgeConfiguration getConfiguration() {
        return this.mod.getConfig();
    }

    @Override
    public String getVersion() {
        return this.mod.getInternalVersion();
    }

    @Override
    public String getPlatformName() {
        return "Forge-Official";
    }

    @Override
    public String getPlatformVersion() {
        return this.mod.getInternalVersion();
    }

    @Override
    public String getId() {
        return "enginehub:forge";
    }

    @Override
    public Map<Capability, Preference> getCapabilities() {
        EnumMap<Capability, Preference> capabilities = new EnumMap<Capability, Preference>(Capability.class);
        capabilities.put(Capability.CONFIGURATION, Preference.PREFER_OTHERS);
        capabilities.put(Capability.WORLDEDIT_CUI, Preference.NORMAL);
        capabilities.put(Capability.GAME_HOOKS, Preference.NORMAL);
        capabilities.put(Capability.PERMISSIONS, Preference.NORMAL);
        capabilities.put(Capability.USER_COMMANDS, Preference.NORMAL);
        capabilities.put(Capability.WORLD_EDITING, Preference.PREFERRED);
        return capabilities;
    }

    @Override
    public Set<SideEffect> getSupportedSideEffects() {
        return ExtendedChunk.class.isAssignableFrom(LevelChunk.class) ? SUPPORTED_SIDE_EFFECTS : SUPPORTED_SIDE_EFFECTS_NO_MIXIN;
    }

    @Override
    public long getTickCount() {
        return ServerLifecycleHooks.getCurrentServer().m_129921_();
    }

    @Override
    public Collection<Actor> getConnectedUsers() {
        ArrayList<Actor> users = new ArrayList<Actor>();
        PlayerList scm = ServerLifecycleHooks.getCurrentServer().m_6846_();
        for (ServerPlayer entity : scm.m_11314_()) {
            if (entity == null) continue;
            users.add(new ForgePlayer(entity));
        }
        return users;
    }
}

