/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.registry;

import com.sk89q.worldedit.registry.Keyed;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public abstract class Category<T extends Keyed> {
    private final Set<T> set = new HashSet<T>();
    private final Supplier<Set<T>> supplier;
    protected final String id;
    private boolean empty = true;

    public Category(String id) {
        this.id = id;
        this.supplier = null;
    }

    public Category(String id, Supplier<Set<T>> contentSupplier) {
        this.id = id;
        this.supplier = contentSupplier;
    }

    public final String getId() {
        return this.id;
    }

    public final Set<T> getAll() {
        if (this.empty) {
            if (this.supplier != null) {
                this.set.addAll((Collection)this.supplier.get());
            } else {
                this.set.addAll(this.load());
            }
            this.empty = false;
        }
        return this.set;
    }

    @Deprecated
    protected abstract Set<T> load();

    public boolean contains(T object) {
        return this.getAll().contains(object);
    }

    public void invalidateCache() {
        this.set.clear();
        this.empty = true;
    }

    public String toString() {
        return this.getId();
    }
}

