/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.linbus.format.snbt.impl;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayDeque;
import org.enginehub.linbus.format.snbt.impl.Elusion;
import org.enginehub.linbus.stream.LinStream;
import org.enginehub.linbus.stream.exception.NbtWriteException;
import org.enginehub.linbus.stream.token.LinToken;
import org.jetbrains.annotations.NotNull;

public class LinSnbtWriter {
    private final ArrayDeque<WriteState> stateStack = new ArrayDeque();

    public void write(@NotNull Appendable output, @NotNull LinStream tokens) throws IOException {
        block35: {
            LinToken token;
            block0: while (true) {
                Buffer buffer;
                WriteState state = this.stateStack.peekLast();
                token = tokens.nextOrNull();
                if (token == null) break block35;
                if (token instanceof LinToken.Name) {
                    LinToken.Name name = (LinToken.Name)token;
                    if (!(state instanceof WriteState.Compound)) {
                        throw new NbtWriteException("Names can only appear inside compounds");
                    }
                    WriteState.Compound compound = (WriteState.Compound)state;
                    if (compound.hasPrevious) {
                        output.append(',');
                        this.replaceLast(new WriteState.Compound(false));
                    }
                    output.append(Elusion.escapeIfNeeded(name.name())).append(':');
                    continue;
                }
                if (token instanceof LinToken.ByteArrayStart) {
                    LinToken.ByteArrayStart byteArrayStart = (LinToken.ByteArrayStart)token;
                    output.append("[B;");
                    continue;
                }
                if (token instanceof LinToken.ByteArrayContent) {
                    LinToken.ByteArrayContent byteArrayContent = (LinToken.ByteArrayContent)token;
                    if (state instanceof WriteState.WritingArray) {
                        output.append(',');
                    } else {
                        this.stateStack.addLast(new WriteState.WritingArray());
                    }
                    buffer = byteArrayContent.buffer();
                    while (true) {
                        if (!buffer.hasRemaining()) continue block0;
                        output.append(String.valueOf(((ByteBuffer)buffer).get())).append('B');
                        if (!buffer.hasRemaining()) continue;
                        output.append(',');
                    }
                }
                if (token instanceof LinToken.ByteArrayEnd) {
                    if (state instanceof WriteState.WritingArray) {
                        this.stateStack.removeLast();
                    }
                    output.append(']');
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof LinToken.Byte) {
                    LinToken.Byte byteValue = (LinToken.Byte)token;
                    output.append(String.valueOf(byteValue.value())).append('B');
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof LinToken.CompoundStart) {
                    output.append('{');
                    this.stateStack.addLast(new WriteState.Compound(false));
                    continue;
                }
                if (token instanceof LinToken.CompoundEnd) {
                    output.append('}');
                    this.stateStack.removeLast();
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof LinToken.Double) {
                    LinToken.Double doubleValue = (LinToken.Double)token;
                    output.append(String.valueOf(doubleValue.value())).append('D');
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof LinToken.Float) {
                    LinToken.Float floatValue = (LinToken.Float)token;
                    output.append(String.valueOf(floatValue.value())).append('F');
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof LinToken.IntArrayStart) {
                    LinToken.IntArrayStart intArrayStart = (LinToken.IntArrayStart)token;
                    output.append("[I;");
                    continue;
                }
                if (token instanceof LinToken.IntArrayContent) {
                    LinToken.IntArrayContent intArrayContent = (LinToken.IntArrayContent)token;
                    if (state instanceof WriteState.WritingArray) {
                        output.append(',');
                    } else {
                        this.stateStack.addLast(new WriteState.WritingArray());
                    }
                    buffer = intArrayContent.buffer();
                    while (true) {
                        if (!buffer.hasRemaining()) continue block0;
                        output.append(String.valueOf(((IntBuffer)buffer).get()));
                        if (!buffer.hasRemaining()) continue;
                        output.append(',');
                    }
                }
                if (token instanceof LinToken.IntArrayEnd) {
                    if (state instanceof WriteState.WritingArray) {
                        this.stateStack.removeLast();
                    }
                    output.append(']');
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof LinToken.Int) {
                    LinToken.Int intValue = (LinToken.Int)token;
                    output.append(String.valueOf(intValue.value()));
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof LinToken.ListStart) {
                    LinToken.ListStart listStart = (LinToken.ListStart)token;
                    output.append('[');
                    this.stateStack.addLast(new WriteState.List(listStart.size().orElseThrow()));
                    continue;
                }
                if (token instanceof LinToken.ListEnd) {
                    output.append(']');
                    this.stateStack.removeLast();
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof LinToken.LongArrayStart) {
                    LinToken.LongArrayStart longArrayStart = (LinToken.LongArrayStart)token;
                    output.append("[L;");
                    continue;
                }
                if (token instanceof LinToken.LongArrayContent) {
                    LinToken.LongArrayContent longArrayContent = (LinToken.LongArrayContent)token;
                    if (state instanceof WriteState.WritingArray) {
                        output.append(',');
                    } else {
                        this.stateStack.addLast(new WriteState.WritingArray());
                    }
                    buffer = longArrayContent.buffer();
                    while (true) {
                        if (!buffer.hasRemaining()) continue block0;
                        output.append(String.valueOf(((LongBuffer)buffer).get())).append('L');
                        if (!buffer.hasRemaining()) continue;
                        output.append(',');
                    }
                }
                if (token instanceof LinToken.LongArrayEnd) {
                    if (state instanceof WriteState.WritingArray) {
                        this.stateStack.removeLast();
                    }
                    output.append(']');
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof LinToken.Long) {
                    LinToken.Long longValue = (LinToken.Long)token;
                    output.append(String.valueOf(longValue.value())).append('L');
                    this.handleValueEnd(output);
                    continue;
                }
                if (token instanceof LinToken.Short) {
                    LinToken.Short shortValue = (LinToken.Short)token;
                    output.append(String.valueOf(shortValue.value())).append('S');
                    this.handleValueEnd(output);
                    continue;
                }
                if (!(token instanceof LinToken.String)) break;
                LinToken.String stringValue = (LinToken.String)token;
                output.append(Elusion.escapeIfNeeded(stringValue.value()));
                this.handleValueEnd(output);
            }
            throw new NbtWriteException("Unknown token: " + token);
        }
    }

    private void handleValueEnd(Appendable output) throws IOException {
        WriteState state = this.stateStack.pollLast();
        if (state == null) {
            return;
        }
        if (state instanceof WriteState.List) {
            WriteState.List list = (WriteState.List)state;
            int remainingValues = list.remainingValues - 1;
            this.stateStack.addLast(new WriteState.List(remainingValues));
            if (remainingValues > 0) {
                output.append(',');
            }
        } else if (state instanceof WriteState.Compound) {
            this.stateStack.addLast(new WriteState.Compound(true));
        } else {
            throw new NbtWriteException("Unexpected state: " + state);
        }
    }

    private void replaceLast(WriteState state) {
        this.stateStack.removeLast();
        this.stateStack.addLast(state);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface WriteState {

        public record WritingArray() implements WriteState
        {
        }

        public record Compound(boolean hasPrevious) implements WriteState
        {
        }

        public record List(int remainingValues) implements WriteState
        {
        }
    }
}

