/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.linbus.tree;

import java.util.Objects;
import org.enginehub.linbus.stream.LinStream;
import org.enginehub.linbus.stream.token.LinToken;
import org.enginehub.linbus.tree.LinTag;
import org.enginehub.linbus.tree.LinTagType;
import org.jetbrains.annotations.NotNull;

public final class LinStringTag
extends LinTag<String> {
    private final String value;

    @NotNull
    public static LinStringTag of(@NotNull String value) {
        return new LinStringTag(value);
    }

    private LinStringTag(@NotNull String value) {
        this.value = Objects.requireNonNull(value, "value is null");
    }

    @Override
    @NotNull
    public @NotNull LinTagType<@NotNull LinStringTag> type() {
        return LinTagType.stringTag();
    }

    @Override
    @NotNull
    public String value() {
        return this.value;
    }

    @Override
    @NotNull
    public LinStream linStream() {
        return LinStream.of((LinToken)new LinToken.String(this.value));
    }
}

